#pragma once

namespace nlc {

/**
 * @brief The logging level for printing out messages to file or console
 */
enum class LogLevel : unsigned int {
	Off = 0,   /*!< Switches off the logging entirely */
	Trace = 1, /*!< Lowest level, logs everything (expect huge logfiles) */
	Debug = 2, /*!< Logs only debug information */
	Info = 3,  /*!< Default level */
	Warn = 4,  /*!< Message about problems that can be recovered */
	Error = 5  /*!< Highest level: message will likely cause an exit of the progam */
};

} // namespace nlc
